#
# mutate a single amino acid - to derivatized version.
# read in coordinates of the original protein and build in the positions of
# the new atoms.
#
#
xplor.requireVersion("2.12")

xplor.parseArguments() # check for typos on the command-line

seq="""
  MET LEU LYS LEU LEU ASP LYS ASN GLY PHE VAL LEU LYS
  LYS VAL GLU ILE TYR ARG SER ASN TYR LEU ALA ILE LEU
  GLU LYS ARG THR ASN GLY ILE ARG ASN PHE GLU ILE ASN
  ASN ASN GLY ASN MET ARG ILE PHE GLY TYR LYS MET MET
  GLU HIS HIS ILE GLN LYS PHE THR ASP ILE GLY MET SER
  CYSP LYS ILE ALA LYS ASN GLY ASN VAL TYR LEU ASP ILE
  LYS ARG SER ALA GLU ASN ILE GLU ALA VAL ILE THR VAL
  ALA SER GLU LEU
"""

simWorld.setRandomSeed(5521)

import protocol
protocol.initTopology(('protein'))
protocol.initParams(('protein'))

import psfGen
psfGen.seqToPSF(seq,seqType='prot',startResid=117)

protocol.initCoords('start.pdb')

#erase all sidechain coords for mutated tag- to make certain they're regenerated
protocol.initCoords(erase=True,
                  selection="resname CYSP and not (name C or name CA or name N)")

notKnown=AtomSel("not known")

protocol.addUnknownAtoms(dyn_stepsize=0.01)
protocol.fixupCovalentGeom(sel=notKnown)


xplor.command("write psf output=new.psf end")
protocol.writePDB("new.pdb")
