#
# more complicated addAtoms example in which a subset of coordinates
# are fixed.
#
#
xplor.requireVersion("2.12")

successFile="addAtoms2.success" # written if script runs ok

import os
try:
    os.unlink(successFile)
except:
    pass

xplor.parseArguments() # check for typos on the command-line

seq="""
MET LEU ARG PHE LEU ASN GLN ALA SER GLN GLY ARG GLY
CYSP TRP LEU LEU MET ALA PHE THR ALA CYSP ALA LEU GLU
LEU THR ALA CYSP TRP PHE GLN HIS VAL MET LEU LEU LYS
PRO CYS VAL LEU SER ILE TYR GLU ARG ALA ALA LEU PHE
GLY VAL LEU CYSP ALA ALA LEU ILE GLY ALA ILE ALA PRO
LYS THR PRO LEU ARG TYR CYSP ALA MET VAL ILE TRP LEU
TYR SER ALA PHE ARG GLY VAL GLN CYSP THR TYR GLU HIS
THR MET LEU GLN LEU TYR PRO SER PRO PHE ALA THR SER
ASP PHE MET VAL ARG PHE PRO GLU TRP LEU PRO LEU ASP
LYS TRP VAL PRO CYSP VAL PHE VAL ALA SER GLY ASP CYS
ALA GLU ARG GLN TRP ASP CYSP LEU GLY LEU GLU MET PRO
GLN TRP LEU LEU GLY ILE PHE ILE CYSP TYR LEU ILE VAL
ALA VAL LEU VAL CYSP VAL CYSP GLN PRO PHE LYS ALA LYS
LYS ARG ASP LEU PHE GLY ARG GLY HIS HIS HIS HIS HIS
HIS 
"""

simWorld.setRandomSeed(5521)

import protocol
protocol.initTopology('protein')
protocol.initParams('protein')

import psfGen
psfGen.seqToPSF(seq,seqType='prot',startResid=1)

# the input pdb has doesn't have MTSL (CYSP) tags - the sequence is
# different
#
protocol.initCoords('dsbbshrt11cys.pdb')

#erase all sidechain coords for mutated tag- to make certain they're regenerated
protocol.initCoords(erase=True,
                  selection="resname CYSP and not (name C or name CA or name N)")

# atoms not in this selection will not be moved at all
#
fixGeom=AtomSel('''(not (name ca or name n or name c or
                 name o or name hn or name ha))
                 and (resid 122 or resid 72 or resid 87 or 
                 resid 152 or resid 161 or resid 163)''')

import protocol, regularize

# using this try...except clause will allow the script to write 
# pdb and psf files even if there was an error in fixupCovalentGeom
#
#
try:
    regularize.addUnknownAtoms_new(dyn_stepsize=0.01)
    protocol.fixupCovalentGeom(sel=fixGeom,verbose=2,useVDW=1)
    open(successFile,"w").write("ok")
except protocol.CovalentViolation:
    pass

# write out new psf and pdb files.
#
xplor.command("write psf output=addAtoms2.psf end")
protocol.writePDB("addAtoms2.pdb")

