#!/usr/bin/env pyXplor

#
# script to generate psf and parameter files for a HETATM residue
# currently, CONECT records are not read, so the whole residue (ligand)
# must be grouped as a rigid body
#

usage='''
genLingand.py [options] <pdb file>

  Generate psf and parameter information from a ATOM or HETATM pdb records.

Currently, CONECT records are not read, so the whole residue (ligand)
must be grouped as a rigid body. i.e. only nonbonded forces will be
calculated. 

Options:
  -resid <num>  - specify resid to process
  -segid <num>  - specify segidd to process
'''

(opts,pdbFiles) = xplor.parseArguments(('resid:1',
                                        'segid:1',
                                        'help-script:0'))

resid=None
segid='    '

for opt in opts:
    if opt[0]=='resid':
        resid=int(opt[1])
        pass
    if opt[0]=='segid':
        segid=opt[1]
        pass
    if opt[0]=='help-script':
        print usage
        import sys; sys.exit(0)
        pass
    pass

nonbondParams=dict(
  C   =    (0.145   ,  3.2072  ,    0.145  ,  3.2072),
  H   =    (0.0498  ,  1.4254  ,    0.0498 ,  1.4254),
  N   =    (0.1592  ,  2.7618  ,    0.1592 ,  2.7618),
  O   =    (0.2342  ,  2.6406  ,    0.2342 ,  2.6406),
  S   =    (0.0239  ,  3.3854  ,    0.0239 ,  3.3854),
  FE  =    (0.01    ,  2.270   ,    0.01   ,  2.270),
  )

masses=dict(
    H =  1.008,
    C = 12.011,
    N = 14.007,
    O = 15.999,
    S = 21.060,
    FE = 55.8470,
    )
    

pdbFile=pdbFiles[0]


def pdbToResInfo(pdbRecord,
                 targetResid=None,
                 targetSegid='',
                 useChainID=True,
                 ):
    """ read pdb record and extract atom info.

    TODO: extract CONECT records

    If useChainID is set, chainID overrides segment name, if it is set.
    """
    ret = []
    curResname=None
    terminate=0
    seg='    '
    previousTerminate=0 #true if one termination atom has been seen
    lines=pdbRecord.split('\n')
    for line in lines:
        if line.startswith('ATOM') or line.startswith('HETATM'): 
            resname = line[17:21]
            resid = int(line[22:26])
            if targetResid==None: targetResid=resid
            if targetResid != resid:
                continue


            seg = line[72:76]
            seg += ' '*(4-len(seg)) # this for truncated ATOM records
            chainID=line[21]
            if (useChainID or seg=='' or seg=='    ') and chainID!=' ':
                seg = chainID
                pass

            #print resid, targetResid, ">%s<" %seg, ">%s<" %targetSegid

    

            if seg != targetSegid:
                continue

            if curResname==None: curResname=resname

            if curResname!=resname:
                raise("curResname!=res: %s != %s" % (curResname,resname))

            name = line[12:16].strip()

            record=(resid,resname,name,segid)
            ret.append( record )
            pass
        pass
            
    return ret



entry= pdbToResInfo(open(pdbFile).read(),resid,segid)

#print len(entry),entry

(resid,resname,name,segid)=entry[0]

print "generating topology, parameters and psf for resname:", resname

def findElement(name,elements):
    ret = name.upper()
    while ret:
        if ret in elements:
            return ret
        ret=ret[:-1]
        pass
    raise Exception("findElement: could not find element for:", name)

residue="residue %s\n" % resname
mass=""
params="""
! auto-generated by genLigand.py
"""
seen=[]
for (resid,resname,name,segid) in entry:
    element=findElement(name,nonbondParams.keys())
    if not element in nonbondParams.keys():
        print "could not find nonbonded parameters for atom named",name
        print "  omitted."
        continue
    typename="G"+name[:3]
    residue += '  atom "%s" type="%s" end\n' % (name,typename)
    massVal = 100
    if element in masses.keys():
        massVal = masses[element]
        pass
    if not typename in seen:
        params += 'nonbonded "%s" ' % typename
        params += "%.4f %.4f %.4f %.4f\n" % nonbondParams[element]
        mass += 'mass "%s" %.4f\n' % (typename, massVal)
        seen.append(typename)
        pass
    pass
residue+="end\n"

topo = "%s\n%s" % (mass,residue)
xplor.command("topology %s end" % topo)

xplor.command('''
      REMARKS  autogenerated by genLigand.py
      segment
        name="%s"
        SETUP=TRUE
        number=%d
        chain
          sequence %s end
        end
      end
''' % (segid,resid,resname))


psfFilename=resname.strip() + ".psf"
paramFilename=resname.strip() + ".par"
topFilename=resname.strip() + ".top"

open(paramFilename,"w").write(params)
open(topFilename,"w").write(topo)
    
xplor.command("write psf output=%s end" % psfFilename)


