# example of generating an extended NAG-modified ASN

import protocol
protocol.initTopology(["protein","nag.top"])
protocol.initParams(["protein","nag.par"])

xplor.command(r"""
segment                                  
   name="a"                              
   SETUP=TRUE                           
   chain
     sequence	
	ASN
  end
 end 
end

 segment                                  
   name="b"                               
   SETUP=TRUE                              
   chain
     sequence
	NAG
  end
 end
end
patch B1N  reference=+=(segi "a" and residue 1) 
           reference=-=(segi "b" and residue 1) end

write structure output=nag-asn.psf end
""")

simWorld.setRandomSeed(341)   #set random seed

try:
    protocol.genExtendedStructure("nag-asn.pdb",verbose=2,
                                  maxFixupIters=200)
except:
    from pdbTool import PDBTool
    PDBTool('t.pdb').write()
    
