# reads in a pdb with a one-character segid and writes out a pdb 
# with the segid written to the ChainID field and the segid field cleared.
# Also, the values in the b-factor column are preserved in the output file.
#
# Finally, missing atoms (with unknown coordinates) are added in with the
# correct covalent geometry


pdbEntry=open("glu.pdb").read()   #the pdb file

import psfGen
psfGen.pdbToPSF(pdbEntry)

import pdbTool
pdb0=pdbTool.PDBTool()
pdb0.setContents(pdbEntry)
pdb0.read() # read coordinates

import trace
trace.suspend()
print "coordinates of the following atoms are not defined:"
known = AtomSel("known")
unknown = AtomSel("not known")
for atom in unknown:
    print atom.string()
trace.resume()

savedCoords=xplor.simulation.atomPosArr()

import protocol
protocol.addUnknownAtoms(verbose=1)
protocol.fixupCovalentGeom(unknown)

pdb1=pdbTool.PDBTool("out.pdb")

import trace
trace.suspend()
for atom in AtomSel("known"):
    pdb1.setAux2(atom, pdb0.aux2(atom) )
    pass        
trace.resume()
  
pdb1.setWriteChainID(True)

pdb1.write()

#extra testing code follows - this should be deleted

if xplor.simulation.numAtoms() != 6707:
    raise Exception("invalid number of atoms: %d" %
                    xplor.simulation.numAtoms())


pdbTool.PDBTool("out.pdb").read()
from vec3 import norm
trace.suspend()
print "testing coordinate positions in output pdb"
for atom in known:
    i = atom.index()
    if norm(atom.pos()-savedCoords[i]) > 1e-4:
        raise Exception("coordinate mismatch for atom: %s" % atom.string())
    pass
