 
xplor.requireVersion("2.17")

numberOfStructures=20
startStructure=0
ensembleSize=4           # number of ensemble members
outFilename = "SCRIPT_%d_STRUCTURE_MEMBER.sa" % ensembleSize

import protocol
protocol.initRandomSeed()

#
# read in the PSF and initial PDB files
#
protocol.initTopology("nucleic-1.0.top")
protocol.initParams("nucleic-1.0.par")

import psfGen
psfGen.pdbToPSF("startB.pdb",customRename=True)
#protocol.initStruct("dna_new.psf")

from ensembleSimulation import EnsembleSimulation
esim = EnsembleSimulation("ensemble",ensembleSize)

# list of potential terms used in refinement
from potList import PotList
potList = PotList()
crossTerms=PotList('cross terms')


# parameters to ramp up during the simulated annealing protocol
#
from simulationTools import MultRamp, StaticRamp, InitialParams
rampedParams=[]

from varTensorTools import create_VarTensor, calcTensor
media={}
for medium in ['phg1','phg2','phg3','bic1','bic2']:
    media[medium] = create_VarTensor(medium)
    pass

#
# starting coords 
#
protocol.initCoords("startB.pdb")

protocol.covalentMinimize("not resname ANI")

from avePot import AvePot
from xplorPot import XplorPot

#planarity restraints
xplor.command("@plane.inp")
potList.append(AvePot(XplorPot("plan",xplor.simulation)) )

#symmetry restraints for the two strands
xplor.command(r"""
ncs restraints
  initialize
   group
         equi ((resid  1:12) )
         equi ((resid 13:24) )
         weight 1.
   end
   ?   {* print the NCS relations when starting *}

end
""")
crossTerms.append( AvePot(XplorPot,"NCS") )
#potList.add( AvePot(XplorPot,"NCS") )
#rampedParams.append( StaticRamp("potList['NCS'].setScale(50)") )


#initialize the aa-aa positional database
xplor.command("@dna_positional.setup")
potList.append(AvePot(XplorPot,"orie") )
rampedParams.append( StaticRamp("potList['ORIE'].setScale(0.2)") )

#NOE potentials
from noePotTools import create_NOEPot
noePots = PotList("noe")
noe = create_NOEPot("noeAll","roe_test2x.tbl")
noe.setPotType("hard")
noePots.append(noe)

# need to be satisfied by all structures
noeHB  = AvePot(create_NOEPot("noeNH","hbond_marius_cds.tbl",
                              esim=xplor.simulation))
noeHB.setPotType("hard")
noeHB.setScale(200)
noePots.append(noeHB)
potList.append(noePots)
rampedParams.append( MultRamp(2,30.,"noePots.setScale( VALUE )") )

protocol.initDihedrals("dihedral_loose.tbl",scale=200)
potList.append(AvePot(XplorPot,"cdih") )

protocol.initRamaDatabase('nucleic')
potList.append(AvePot(XplorPot,"rama") )
rampedParams.append( MultRamp(0.2,0.2,"xplor.command('rama scale VALUE end')"))

import solnXRayPotTools
solnXRayPotTools.solventVolume = solnXRayPotTools.solventVolumeSets['tiede']
from solnXRayPotTools import create_solnXRayPot
xray61 = create_solnXRayPot('xray61',"not name H*","expt_61.dat",
                            radiusScale=0.96)
xray61.setNormalizeIndex(14)
xray30 = create_solnXRayPot('xray30',"not name H*","expt_30.dat",
                            radiusScale=0.96)
xray30.setNormalizeIndex(7)

xray      = xray30
xrayCross = xray61

solnXRayPotTools.useGlobs(xray)
xray.setNumAngles(100)
xrayCross.setCalcType('n2')

xray.setScale(4000)
crossTerms.append(xrayCross)
potList.append(xray)
#corrects I(q) to the true Debye result
rampedParams.append( StaticRamp("xray.calcGlobCorrect('n2')") )

from rdcPotTools import Da_prefactor, create_RDCPot, scale_toCH

from csaPotTools import create_CSAPot
csaPots = PotList("csa")
for (name,medium,force,tbl) in [("POP", 'phg3',1,"justin_csa.tbl"),
                                ("POP2",'bic2',1,"justin_csa_bcl.tbl")]:
    term = create_CSAPot(name,oTensor=media[medium],file=tbl)
    term.setShowAllRestraints(1)
    #rescale to CH normalization
#    term.setDaScale( -term.DaScale() /
#                     (Da_prefactor['CH'] / Da_prefactor["NH"]) )
    term.setDaScale( -term.DaScale() )
    term.setScale(force)
    csaPots.append( term )
    pass

potList.append(csaPots)
rampedParams.append( MultRamp(0.01,0.2,"csaPots.setScale( VALUE )") )


# Rh same for jch2 and phos/pho2, but da is different
# let's add this later with a cosRatio2 potential term

rdcPots = PotList('rdcs')
# weight is the relative weighting of expts, as determined by expt. error
for (name,medium,weight,files) in [
    ('JCH' ,'bic1',1   ,('dipolar_ribose_nico.tbl',
                           'dipolar_c2_sum2.tbl')), #remove
    ('JCHB','bic1',1   ,'dipolar_base.tbl'),
    ('JCNB','bic1',1   ,'dipolar_imino.tbl'),
    ('JCMT','bic1',1   ,'dipolar_methyl.tbl'),
    ('JADR','bic1',1./5,('dipolar_ribose_add.tbl',
                           'dipolar_c2.tbl', #??
                           'dipolar_c5_nico.tbl')),
    ('JADB','bic1',1./8,'dipolar_base_add.tbl'),
    ('JCH2','phg1',1   , #'dipolar_CH_phg.tbl'), no longer used??
                           ('DNA198-CH-20mgpf1-xplor.tbl',
                            'dipolar_c2_sum2_DNA198-20mgpf1.tbl')),
    ('JCH3','phg1',1   ,('dipolar_c2_sum2_DNA200-18mgpf1.tbl',
                           'DNA200-CH-18mgpf1-0mMMg-xplor.tbl')),
    ('JNH2','phg1',1   ,'dipolar_NH_phg.tbl'),
    ('HABS','bic1',1   ,'HH_dipolar-nico.tbl'),
                           #'HH_dipolar.tbl'), this in original
    ('HSIG','bic1',1   ,('HH_dipolar_sign-nico.tbl',
                           'HH_dipolar_sign2-nico.tbl')),
    ('HAB2','phg2',1   ,'HH_dip-20mgphg-nosign.tbl'),
    ('HSI2','phg2',1   ,('HH_dip-20mgphg-sign.tbl',
                         'HH_dip-20mgphg-sign2-new.tbl')),
    ('PHOS','phg3',100 ,'dipolar_ph.tbl'),
    ('PHO2','bic2',100 ,'dipolar_ph_bcl.tbl'),
    ]:
    term = create_RDCPot(name,oTensor=media[medium])
    term.setShowAllRestraints(1)
    if type(files)==type('string'):
        files=(files,)
        pass
    for file in files:
        term.addRestraints( open(file).read() )
        pass
    
    term.setScale( weight )
    #term.setAveType("average")
    term.setAveType("sum")
    print name
    scale_toCH(term) #also sets useDistance
    print term.info()
    print term.gyroA()
    rdcPots.append(term)
    pass


# proton setup
for key in ('HABS', 'HAB2'): rdcPots[key].setUseSign(0)

for key in ('HABS', 'HSIG', 'HAB2', 'HSI2'):
    rdcPots[key].setPotType('square');
    rdcPots[key].setAveType('sum')
    pass

potList.append(rdcPots)
rampedParams.append( MultRamp(0.01,1,"rdcPots.setScale( VALUE )") )


from rdcPotTools import Da_prefactor

print "factor:", Da_prefactor['CH'] / Da_prefactor["NH"]
for medium in media.values():
    calcTensor(medium)
    print "medium: ", medium.instanceName(), \
          "Da: ",medium.Da(), "Rh: ",medium.Rh()
    pass

#let's try fixing Da, Rh:
for (medium,Da,Rh) in (('bic1',-16,.26),
                       ('bic2',-26.6,0.09),
                       ('phg1',-23,0.06),
                       ('phg2',-16.5,0.06),
                       ('phg3',-20.0,0.06)):
    medium = media[medium]
    medium.setDa(Da)
    medium.setRh(Rh)
    pass


# set up J coupling
from jCoupPotTools import create_JCoupPot
jCoup = create_JCoupPot("jcoup","couplings.tbl",
                        A=15.3,B=-6.1,C=1.6,phase=0 )
jCoup.setThreshold(0)
jCoup.setScale(10)
potList.append(jCoup)

#rap term to keep members of ensemble in similar orientations
from posRMSDPotTools import RAPPot
rap = RAPPot("rap","name P")
rap.setScale( 100.0 )
rap.setPotType( "square" )
rap.setTol( 0.5 )
potList.append(rap)
#crossTerms.append(rap)

#measure of difference between ensemble members
posRMSD = RAPPot("posRMSD","not name H* and not resname ANI")
crossTerms.append(posRMSD)

from orderPotTools import create_OrderPot
orderPot = create_OrderPot("s2","order.tbl")
orderPot.setScale(10000)
orderPot.setPotType('square')
orderPot.setShowAllRestraints(1)
#potList.add( orderPot )
crossTerms.append(orderPot)

protocol.initNBond(cutnb=4.5)
potList.append( AvePot(XplorPot,"VDW") )
rampedParams.append( MultRamp(0.9,0.78,
                              "xplor.command('param nbonds repel VALUE end end')") )
rampedParams.append( MultRamp(.004,4,
                              "xplor.command('param nbonds rcon VALUE end end')") )

for name in ("bond","angl","impr"):
    potList.append( AvePot(XplorPot,name) )
    pass
rampedParams.append( MultRamp(0.4,1.0,"potList['ANGL'].setScale(VALUE)"))
rampedParams.append( MultRamp(0.1,1.0,"potList['IMPR'].setScale(VALUE)"))


import shapePotTools
from shapePot import ShapePot
shape = ShapePot("shape","not resname ANI and not name H*")
shape.setSizeScale( 10)
shape.setOrientScale( 0 )
shape.setSizePotType("square") #allow 1 unit size error
shape.setSizeTol(1)
shape.setTargetType("pairwise")
potList.add( shape )

orient = PotList('orient')

# selection for ``bar-def'' base pair atoms
barAtoms =  "not name H* and (name C* or name N* or name O4' or name O#)"
for resids in [(4,21),(5,20),(6,19),(7,18),(8,17),(9,16)]:
    p = ShapePot('ori-%d-%d' % resids,
                 "(resid %d or resid %d) and (%s)" % (resids[0],resids[1],
                                                    barAtoms)          )
    p.setSizeScale( 0 )
    p.setOrientScale( 50 )
    p.setOrientPotType("square") #allow 10 degree orientation error
    p.setOrientTol(10.)
    p.setTargetType("pairwise")
    orient.append(p)
    
#
p = ShapePot("orient","not resname ANI and not name H*")
p.setSizeScale( 0 )
p.setOrientScale( 50 )
p.setOrientPotType("square") #allow 1 degree orientation error
p.setOrientTol(1.)
p.setTargetType("pairwise")
orient.append(p)

potList.add( orient )
rampedParams.append( MultRamp(50,500,"orient.setScale(VALUE)") )


from ivm import IVM
import varTensorTools
mini = IVM()             #initial alignment of orientation tensor axes
#map(lambda x: mini.potList().append(x), (rdcPots, csaPots) )
for medium in ('bic1','phg1'): media[medium].setFreedom("fixDa, fixRh")
for medium in ('bic2',):
    media[medium].setFreedom("fixDa, fixRh, fixAxisTo bic1")
for medium in ('phg2','phg3',):
    media[medium].setFreedom("fixDa, fixRh, fixAxisTo phg1")
varTensorTools.topologySetup(mini,media.values())

protocol.initMinimize(mini,
                      numSteps=20)
mini.fix("not resname ANI")
mini.run()               #this initial minimization is not strictly necessary

#uncomment to allow Da, Rh to vary
for medium in ('bic1','phg1'): media[medium].setFreedom("varyDa, varyRh")
for medium in ('bic2',):
    media[medium].setFreedom("varyDa, varyRh, fixAxisTo bic1")
for medium in ('phg2','phg3',):
    media[medium].setFreedom("varyDa, fixRhTo phg1, fixAxisTo phg1")

dyn = IVM()
protocol.initDynamics(dyn,potList=potList)
protocol.torsionTopology(dyn,oTensors=media.values())

#
#
# Give atoms uniform weights, except for the anisotropy axis
from atomAction import SetProperty
AtomSel("not resname ANI").apply( SetProperty("mass",100.) )
import varTensorTools
varTensorTools.massSetup(media.values(),300)
AtomSel("all            ").apply( SetProperty("fric",10.) )


##
## minc used for final cartesian minimization
##
from selectTools import IVM_groupRigidSidechain
minc = IVM()
protocol.initMinimize(minc,potList=potList)
IVM_groupRigidSidechain(minc)
protocol.cartesianTopology(minc,"not resname ANI")
varTensorTools.topologySetup(minc,media.values())

init_t = 3000
annealTime=0.2     #time to integrate at a given annealing temp.
annealSteps=0    #max num steps to be taken during a single annealing temp.

class DynMin:
    """class to perform minimization followed by dynamics
    """
    def __init__(s,ivm):
        s.ivm = ivm
        return
    def setBathTemp(s,temp):
        s.ivm.setBathTemp(temp)
        return
    def setETolerance(s,tol):
        s.ivm.setETolerance(tol)
        return
    def run(s):
        #protocol.initMinimize(s.ivm,
        #                      numSteps=1000)
        #s.ivm.run()
        protocol.initDynamics(s.ivm,
                              finalTime=annealTime,
                              numSteps=annealSteps,
                              eTol_minimum=0.001
                              )
        s.ivm.run()
        return

from simulationTools import AnnealIVM
anneal= AnnealIVM(initTemp =init_t,
                  finalTemp=25,
                  tempStep =25,
                  ivm=DynMin(dyn),
                  rampedParams = rampedParams)
    

# initialize parameters for initial minimization.
InitialParams( rampedParams )

# initial minimization
protocol.initMinimize(dyn,
                      numSteps=1000)
dyn.run()

#short symmetry-breaking dynamics run
protocol.initDynamics(dyn,
                      bathTemp=init_t,
                      initVelocities=1,
                      finalTime=0.1,
                      numSteps=1000)
dyn.run()
# minimize symmetry-broken ensemble
protocol.initMinimize(dyn,
                      numSteps=1000)
dyn.run()

from simulationTools import testGradient
#testGradient(potList,eachTerm=1)

from pdbTool import PDBTool
def calcOneStructure(loopInfo):

    # initialize parameters for high temp dynamics.
    InitialParams( rampedParams )

    # high temperature bit - using only P-P nonbonded terms
    protocol.initNBond(repel=1.2,
                       cutnb=100,
                       tolerance=45,
                       selStr="name P")
    protocol.initDynamics(dyn,
                          initVelocities=1,
                          bathTemp=init_t,
                          potList=potList,
                          numSteps=5000,
                          finalTime=10)
    dyn.run()
    protocol.initNBond() #reset to include all atoms

    # perform simulated annealing
    #
    anneal.run()
              
    #
    # torsion angle minimization
    #
    protocol.initMinimize(dyn)
    dyn.run()

    ##
    ##all atom minimization
    ##
    minc.run()

    #
    # perform analysis and write structure
    loopInfo.writeStructure(potList,crossTerms)

    # calculate regularized ensemble ave. struct.
    aveFilename = outFilename.replace('MEMBER','ave')

    savedCoords = esim.atomPosArr()
    esim.setAtomPosArr( esim.meanAtomPosArr() )

    from simulationTools import minimizeRefine
    minimizeRefine(potList=potList,
                   refineSteps=50)

    if esim.singleThread():
        PDBTool(loopInfo.makeFilename(aveFilename),
                "not resname ANI").write()
        
        pass
    esim.multiThread()
    esim.setAtomPosArr( savedCoords )

    pass


from simulationTools import StructureLoop, FinalParams
StructureLoop(numStructures=numberOfStructures,
              startStructure=startStructure,
              structLoopAction=calcOneStructure,
              pdbTemplate=outFilename,
              genViolationStats=1,
              averageTopFraction=0.5,
              averagePotList=potList,
              averageCrossTerms=crossTerms,
              averageContext=FinalParams(rampedParams),
              averageFilename="ave.pdb",
              averageFitSel="not name H* and not resname ANI",
              averageCompSel="not name H* and not resname ANI"       ).run()

