#!/usr/bin/env pyXplor

import sys
import psfGen
import protocol
from math import sqrt
from atomSelAction import RMSD, Fit

usage = """usage: %s [options] <structure files to be compared>

option are zero or more of
  -selection <XPLOR selection> - specify atoms used in comparison.
  -fitSelection <selection>    - specify atoms used to best-fit structures.
  -psf          <psf file>     - psf file. If omitted, it is auto-generated.
  -noFit                       - omit the fitting procedure. If not
                                 specified, the structures are best-fitted
                                 before pairwise RMSD calculation.

Structures are first best-fit, and then the rmsd is calculated. This is done
for each pair of structures. The average, deviation, min and max rmsd are
printed.

""" % sys.argv[0]


(opts,pdbFiles) = xplor.parseArguments(('selection:1','fitSelection:1',
                                        'psf:1',
                                        'help-script','noFit:0'))

sel="not hydro and not resname ANI"
fitSel=None
psf=None
nFit=0
for opt in opts:
    if opt[0]=='help-script':
        print
        print usage
        sys.exit(0)
    if opt[0]=='selection':
        sel = opt[1]
    elif opt[0]=='fitSelection':
        fitSel = opt[1]
    elif opt[0]=='psf':
        psf = opt[1]
    elif opt[0]=='noFit':
        nFit=1
        pass
    pass

if not pdbFiles:
    raise Exception("at least one pdb file must be specified")

if not fitSel:
    fitSel = sel
    pass

if psf:
    protocol.initStruct(psf)
else:
    psfGen.pdbToPSF(pdbFiles[0])
    
protocol.initCoords(pdbFiles[0])
unknown=AtomSel("not known")
if len(unknown)>0:
    print "deleting %d atoms with unknown coordinates" % len(unknown)
    pass
xplor.command("delete sele=(not known) end")

sim=xplor.simulation


cnt=0
sum=0.
variance=0.
mini=1e20
maxi=0.
coords=[]
for i in range(len(pdbFiles)):
    protocol.initCoords(pdbFiles[i])
    coords.append( sim.atomPosArr() )
    pass

for i in range(len(pdbFiles)):
    comp = coords[i]
    for j in range(i+1,len(pdbFiles)):
        sim.setAtomPosArr( coords[j] )
        cnt+=1
        measure = RMSD(comp)
        if nFit==0:
            AtomSel('all').apply( Fit(comp,fitSel) )
        AtomSel(sel).apply( measure )

        sum += measure.rmsd()
        variance += measure.rmsd()**2
        mini=min(mini,measure.rmsd())
        maxi=max(maxi,measure.rmsd())
        pass
    pass

ave = sum / cnt
sdev = sqrt( variance/cnt  - ave**2 )

print 'pairwise rmsd:',
print 'ave: %.4f   std dev: %.4f   min: %.4f   max: %.4f' % \
      (ave,sdev,mini,maxi)
        
        
