
xplor.requireVersion("2.26")

inputStructuresGlob="precalc/refine_[0-9]*.sa"

import glob
inputStructures=glob.glob(inputStructuresGlob)
#this could also be a list of filenames


simWorld.setRandomSeed( 785 )


import protocol

backbone="name C or name CA or name N or name O or name HN"

#Nilges topology/parameters
xplor.command('evaluate ($par_nonbonded = "OPLSX")')
protocol.parameters['protein']="waterRef/parallhdg5.3.pro.new"
protocol.parameters['water']  ="waterRef/parallhdg5.3.sol"
protocol.topology['protein']  ="waterRef/topallhdg5.3.pro.new"
protocol.topology['water']    ="waterRef/topallhdg5.3.sol"
waterResname="TIP3"
protocol.initParams(("protein","ion.par"))

#protocol.initStruct("zc2h2_waterref.psf")
protocol.loadPDB(inputStructures[0],deleteUnknownAtoms=True)

from potList import PotList
from simulationTools import MultRamp, StaticRamp, FinalParams
potList = PotList()
rampedParams=[]

# orientation Tensor - used with the dipolar coupling term
#  one for each medium
#   For each medium, specify a name, and initial values of Da, Rh.
#
from varTensorTools import create_VarTensor
media={}
#                        medium  Da   rhombicity
for (medium,Da,Rh) in [ ('t',   -6.5, 0.62),
                        ('b',   -9.9, 0.23) ]:
    oTensor = create_VarTensor(medium)
    oTensor.setDa(Da)
    oTensor.setRh(Rh)
    media[medium] = oTensor
    pass
    

# dipolar coupling restraints for protein amide NH.  
#
# collect all RDCs in the rdcs PotList
#
# RDC scaling. Three possible contributions.
#   1) gamma_A * gamma_B / r_AB^3 prefactor. So that the same Da can be used
#      for different expts. in the same medium. Sometimes the data is
#      prescaled so that this is not needed. scale_toNH() is used for this.
#      Note that if the expt. data has been prescaled, the values for rdc rmsd
#      reported in the output will relative to the scaled values- not the expt.
#      values.
#   2) expt. error scaling. Used here. A scale factor equal to 1/err^2
#      (relative to that for NH) is used.
#   3) sometimes the reciprocal of the Da^2 is used if there is a large
#      spread in Da values. Not used here.
#
from rdcPotTools import create_RDCPot, scale_toNH
rdcs = PotList('rdc') 
for (medium,expt,file,                 scale) in \
    [('t','NH' ,'tmv107_nh.tbl'       ,1),
     ('t','NCO','tmv107_nc.tbl'       ,.05),
     ('t','HNC','tmv107_hnc.tbl'      ,.108),
     ('b','NH' ,'bicelles_new_nh.tbl' ,1),
     ('b','NCO','bicelles_new_nc.tbl' ,.05),
     ('b','HNC','bicelles_new_hnc.tbl',.108)
     ]:
    rdc = create_RDCPot("%s_%s"%(medium,expt),file,media[medium])

    #1) scale prefactor relative to NH
    #   see python/rdcPotTools.py for exact calculation
    # scale_toNH(rdc) - not needed for these datasets -
    #                        but non-NH reported rmsd values will be wrong.

    #3) Da rescaling factor (separate multiplicative factor)
    # scale *= ( 1. / rdc.oTensor.Da(0) )**2
    rdc.setScale(scale)
    rdc.setShowAllRestraints(1) #all restraints are printed during analysis
    rdc.setThreshold(1.5)       # in Hz
    rdcs.append(rdc)
    pass
potList.append(rdcs)
rampedParams.append( MultRamp(0.05,5.0, "rdcs.setScale( VALUE )") )

# calc. initial tensor orientation
# and setup tensor calculation during simulated annealing
#
from varTensorTools import calcTensorOrientation, calcTensor
for medium in media.keys():
    calcTensorOrientation(media[medium])
    rampedParams.append( StaticRamp("calcTensor(media['%s'])" % medium) )
    pass

# set up NOE potential
noe=PotList('noe')
potList.append(noe)
from noePotTools import create_NOEPot
for (name,scale,file) in [('all',1,"noe_sum_3.tbl"),
                          #add entries for additional tables
                          ]:
    pot = create_NOEPot(name,file)
    # pot.setPotType("soft") - if you think there may be bad NOEs
    pot.setScale(scale)
    noe.append(pot)
rampedParams.append( MultRamp(2,30, "noe.setScale( VALUE )") )

# set up J coupling - with Karplus coefficients
from jCoupPotTools import create_JCoupPot
jCoup = create_JCoupPot("jcoup","jna_coup.tbl",
                        A=6.98,B=-1.38,C=1.72,phase=-60.0)
potList.append(jCoup)

# Set up dihedral angles
from xplorPot import XplorPot
protocol.initDihedrals("dihed_g_all.tbl",
                       useDefaults=False)
potList.append( XplorPot('CDIH') )
rampedParams.append( StaticRamp("potList['CDIH'].setScale(200)") )

from simulationTools import StructureLoop


def calcOneStructure( structData ):
    from waterRefineTools import refine
    refine(outFilename=structData.filename(),
           potList=potList,
           coolingParams=rampedParams,
#           keepWaters=True,
           waterResname=waterResname)
    pass


StructureLoop(pdbFilesIn=inputStructures,
              pdbTemplate="SCRIPT_STRUCTURE.sa",
              structLoopAction=calcOneStructure,
              genViolationStats=True,
              averagePotList=potList,
              averageContext=FinalParams(rampedParams),
              ).run()
