#
# Converts the final Marvin restraints list to 
# the "classic" xplor format, removing all 
# assignments whose likelihood is less then 90%
#

package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]


initParamPsfPdb \
    -psfFileName  ./cvn.psf \
    -randomCoords


#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}


set 3dc [create_MarvinNOEPotential 3dcNOEs]
set 3dn [create_MarvinNOEPotential 3dnNOEs]

readShiftAssignments \
    -fileName cvn_3dc_final.shiftAssignments \
    -pot $3dc

readMarvinPeaks \
    -fileName cvn_3dc_final.peaks \
    -pot $3dc


readShiftAssignments \
    -fileName cvn_3dn_final.shiftAssignments \
    -pot $3dn

readMarvinPeaks \
    -fileName cvn_3dn_final.peaks \
    -pot $3dn


removeLowLikelihoodPeakAssignments \
    -pot $3dc \
    -likelihoodCutoff 0.9

removeLowLikelihoodPeakAssignments \
    -pot $3dn \
    -likelihoodCutoff 0.9



writeXplorNOEs \
    -fileName "cvn_3dc_xplor_noes.tbl" \
    -peakList [$3dc peaks] \
    -remarks [list "Converted from final Marvin NOEs" \
		  "Low-likelihood assignments were removed"]


writeXplorNOEs \
    -fileName "cvn_3dn_xplor_noes.tbl" \
    -peakList [$3dn peaks] \
    -remarks [list "Converted from final Marvin NOEs" \
		  "Low-likelihood assignments were removed"]

exit
