package require aeneas
package require pipp
package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]

initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}


set noe [create_MarvinNOEPotential marv]

set peakRemarks [list]
set saRemarks [list]

#
# read the chemical shift table
#

set shifts [readPippShiftTable -fileName ./cvn_c13noe.shifts -remarksVariableName saRemarks] ; noOutput

reportUnassignedAtoms \
    -shiftList $shifts \
    -remarksVariableName saRemarks

# 
# this spectrum was taken in D2O.  Therefore, don't create to shiftAssignments 
# for exchangeable protons
#

set tempString "(name h* and not (name hn or name ht* or (resn thr and name hg1) or 
                                 (resn ser and name hg) or (resn lys and name hz*) or 
                                 (resn tyr and name hh) or (resn arg and name hh*) or
                                 (resn arg and name he) or (resn asn and name hd*) or
                                 (resn gln and name he*)))"


#
# Note that this procedure throws warnings about shift table entries 
# selecting no atoms when this script is run in quick mode
#

createShiftAssignments \
    -shiftList $shifts \
    -pot $noe \
    -fromProtonSelectionString "(name h* and bondedto (name c*))" \
    -fromHeavyatomSelectionString "(name c*)" \
    -toProtonSelectionString $tempString \
    -fromProtonSolventRange [list 4.6 4.8] \
    -namePrefix "3dc" \
    -remarksVariableName saRemarks

#
# read the peak table
#

#
# read the NOE peak table.  Make sure that the 
# columns are identified correctly
#

if {$quickMode} {

    #
    # quick mode only bothers with a subset of the peaks--
    # those that can be assigned at all with the residue 1:36 subset
    #

    process3dCPippPeakTable -fileName ./subset_3dc.PCK  \
	-peakIDcolumnName PkID \
	-fromProtonColumnName X \
	-fromCarbonColumnName Z \
	-toProtonColumnName Y \
	-intensityColumnName Intensity \
	-pot $noe \
	-remarksVariableName peakRemarks

} else {

    process3dCPippPeakTable -fileName ./3dc_capp_def.PCK  \
	-peakIDcolumnName PkID \
	-fromProtonColumnName X \
	-fromCarbonColumnName Z \
	-toProtonColumnName Y \
	-intensityColumnName Intensity \
	-pot $noe \
	-remarksVariableName peakRemarks
}


standard3dInitMatch -pot $noe \
    -fromProtonSpectralRangePPM  [readSpectralRangeFromPippPeakTable -fileName ./3dc_capp_def.PCK -axis X_AXIS] \
    -fromHeavyatomSpectralRangePPM [readSpectralRangeFromPippPeakTable -fileName ./3dc_capp_def.PCK -axis Z_AXIS] \
    -toProtonSpectralRangePPM [readSpectralRangeFromPippPeakTable -fileName ./3dc_capp_def.PCK -axis Y_AXIS] \
    -basePhase negative \
    -fromProtonSolventRange [list 4.6 4.8] \
    -referenceStructureFile ./cvn_reference.pdb \
    -exceptionsFileName ./cvn_3dc.exceptions \
    -peakFileName       ./cvn_3dc_pass1.peaks \
    -shiftAssignmentsFileName  ./cvn_3dc_pass1.shiftAssignments \
    -peakRemarksVariableName peakRemarks \
    -saRemarksVariableName   saRemarks 


puts $errorInfo

exit
