package require aeneas
package require pipp
package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]

initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}


set noe [create_MarvinNOEPotential marv]

set peakRemarks [list]
set saRemarks [list]

#
# read the chemical shift table
#

set shifts [readPippShiftTable -fileName ./cvn_n15noe.shifts \
		-remarksVariableName saRemarks] ; noOutput

#
# Note that this procedure throws warnings about shift table entries 
# selecting no atoms when this script is run in quick mode
#

createShiftAssignments \
    -shiftList $shifts \
    -pot $noe \
    -fromProtonSelectionString "(name h* and bondedto (name n*))" \
    -fromHeavyatomSelectionString "(name n*)" \
    -toProtonSelectionString "(name h*)" \
    -namePrefix "3dn" \
    -remarksVariableName saRemarks


#
# read the NOE peak table.  Make sure that the 
# columns are identified correctly
#

if {$quickMode} {

    #
    # quick mode only bothers with a subset of the peaks--
    # those that can be assigned at all with the residue 1:36 subset
    #

    process3dNPippPeakTable -fileName ./subset_3dn.PCK  \
	-peakIDcolumnName PkID \
	-fromProtonColumnName X \
	-fromNitrogenColumnName Z \
	-toProtonColumnName Y \
	-intensityColumnName Intensity \
	-pot $noe \
	-remarksVariableName peakRemarks

} else {

    process3dNPippPeakTable -fileName ./3dn_capp_def.PCK \
	-peakIDcolumnName PkID \
	-fromProtonColumnName X \
	-fromNitrogenColumnName Z \
	-toProtonColumnName Y \
	-intensityColumnName Intensity \
	-pot $noe \
	-remarksVariableName peakRemarks

}

standard3dInitMatch -pot $noe \
    -fromProtonSpectralRangePPM  [readSpectralRangeFromPippPeakTable -fileName ./3dn_capp_def.PCK -axis X_AXIS] \
    -fromHeavyatomSpectralRangePPM [readSpectralRangeFromPippPeakTable -fileName ./3dn_capp_def.PCK -axis Z_AXIS] \
    -toProtonSpectralRangePPM [readSpectralRangeFromPippPeakTable -fileName ./3dn_capp_def.PCK -axis Y_AXIS] \
    -basePhase positive \
    -referenceStructureFile ./cvn_reference.pdb \
    -exceptionsFileName ./cvn_3dn.exceptions \
    -peakFileName       ./cvn_3dn_pass1.peaks \
    -shiftAssignmentsFileName  ./cvn_3dn_pass1.shiftAssignments \
    -peakRemarksVariableName peakRemarks \
    -saRemarksVariableName   saRemarks 


puts $errorInfo

exit
