package require aeneas

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]

#
# initialization
#

initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}

#
# set up the 3dC NOEs
#

XplorCommand "set message off echo off end"

set noe_3dc [create_MarvinNOEPotential 3dC]
$noe_3dc useSingleAssignmentBehavior

readShiftAssignments \
    -fileName "cvn_3dc_pass1.shiftAssignments" \
    -pot $noe_3dc

readMarvinPeaks \
    -fileName "cvn_3dc_pass1.peaks" \
    -pot $noe_3dc

readExplicitInverseExceptions \
    -fileName "cvn_3dc.exceptions" \
    -pot $noe_3dc

#
# set up the 3dN NOEs
#

XplorCommand "set message off echo off end"

set noe_3dn [create_MarvinNOEPotential 3dN]
$noe_3dn useSingleAssignmentBehavior

readShiftAssignments \
    -fileName "cvn_3dn_pass1.shiftAssignments" \
    -pot $noe_3dn

readMarvinPeaks \
    -fileName "cvn_3dn_pass1.peaks" \
    -pot $noe_3dn

readExplicitInverseExceptions \
    -fileName "cvn_3dn.exceptions" \
    -pot $noe_3dn

standardJointFilter  \
    -potList                      [list $noe_3dc $noe_3dn] \
    -exceptionsFileNameList       [list cvn_3dc.exceptions cvn_3dn.exceptions] \
    -peakFileNameList             [list cvn_3dc_pass2.peaks cvn_3dn_pass2.peaks] \
    -shiftAssignmentsFileNameList [list cvn_3dc_pass2.shiftAssignments cvn_3dn_pass2.shiftAssignments] \
    -referenceStructureFile       ./cvn_reference.pdb 


puts $errorInfo

exit
