#!/usr/bin/env pyXplor

#script to generate contact map
#  see Kuszewski et al. J. Biomol. NMR 41, 221-239 (2008).
#
# usage: ./makeContactMap <joinFilter.out> [ref struct pdb]
#
# joinFilter.out is the output of the joint filter script
# the second argument is the name of an optional reference pdb file.
#

(opts,args) = xplor.parseArguments(["Rc:1",
                                    "outFile:1"])

jointFilterFile=args[0]
refPDB=None
if len(args)>1:
    refPDB=args[1]
    pass

Rc=None
outFilename=None
for opt in opts:
    if opt[0]=="Rc":
        Rc=float(opt[1])
        pass
    if opt[0]=="outFile":
        outFilename=opt[1]
        pass
    pass

contents=file(jointFilterFile).readlines()

scores=[]
for line in contents:
    if line.startswith("Final residue pair score"):
        fields=line.split()
        (resid1, rname, intra0, intra1, score, passed) = fields[-6:]
        try:
            resid0=int(fields[4])
        except:
            resid0=int(fields[5])
            pass

        if Rc!=None:
            passed=(float(score)>Rc)
            pass

        scores.append((resid0, int(resid1), float(passed)))
        pass
    pass

minResid=min(map(lambda t:t[0], scores))
minResid=min(minResid,min(map(lambda t:t[1], scores)))
maxResid=max(map(lambda t:t[0], scores))
maxResid=max(maxResid,max(map(lambda t:t[1], scores)))


from pylab import subplot, pcolor, title, ndarray, show, get_cmap

print maxResid
array=[[]]*(maxResid+1)
array=ndarray((maxResid+1,maxResid+1))

import pylab
x=[]
y=[]
networkContacts=[]
for i in range(maxResid+1):
    networkContacts.append([])
    pass
numContacts=0
for (r0,r1,s) in scores:
    if s>0.:
        networkContacts[r0].append(r1)
        numContacts+=1
        pass
    pass

print 'num network contacts:', numContacts
#        
#        x.append(r0)
#        y.append(r1)
##    if s!=0.: print r0,r1,s
#    pass

cutoff=4
physContacts=[]
for i in range(maxResid+1):
    physContacts.append([])
    pass
numContacts=0
if refPDB:
    from atomSelAction import minDistance
    import protocol
    protocol.loadPDB(refPDB,deleteUnknownAtoms=True)
    #from selectTools import minResid, maxResid
    for i in range(maxResid+1):
        for j in range(i+1,maxResid+1):
            if minDistance(AtomSel("resid %d"%i),
                           AtomSel("resid %d"%j))<cutoff:
                physContacts[i].append(j)
                physContacts[j].append(i)
                numContacts+=1
#                x.append(i)
#                y.append(j)
                pass
            pass
        pass
    pass

print 'num physical contacts:', numContacts

falseContacts=[]
trueContacts=[]
missingContacts=[]

for i in range(len(networkContacts)):
    for j in networkContacts[i]:
        if j in physContacts[i]:
            trueContacts.append((i,j))
        elif i>j:
            falseContacts.append((i,j))
            pass
        pass
    pass
for i in range(len(physContacts)):
    for j in physContacts[i]:
        if not j in networkContacts[i] and i<j:
            missingContacts.append((i,j))
            pass
        pass
    pass

print 'false', len(falseContacts)
print 'missing', len(missingContacts)
print 'correct', len(trueContacts)

manager = pylab.get_current_fig_manager() 
manager.window.title(jointFilterFile)
            

x=pylab.array(x)
y=pylab.array(y)
pylab.xticks(pylab.arange(0,maxResid,25))
pylab.yticks(pylab.arange(0,maxResid,25))

p = subplot(111)

x=pylab.array(map(lambda t:t[0], falseContacts))
y=pylab.array(map(lambda t:t[1], falseContacts))
p.plot(x,y,'gs')

x=pylab.array(map(lambda t:t[0], missingContacts))
y=pylab.array(map(lambda t:t[1], missingContacts))
p.plot(x,y,'rs')

x=pylab.array(map(lambda t:t[0], trueContacts))
y=pylab.array(map(lambda t:t[1], trueContacts))
p.plot(x,y,'ks')

p.set_xlabel("Residue Number",size=20)
p.set_ylabel("Residue Number",size=20)

p.grid(True)


#axis([2,20,2,14])
#setp(gca(), xticklabels=[], yticks=(4,8,12), xticks=(0,10,20))
#text(3,12, 'I', fontsize=20)


title('contact map')

if outFilename:
    pylab.savefig(outFilename)
else:
    show()
    pass
