#
# cyanovirin test
#

package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]

#
# initialization
#

initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}


#
# read in the 3dC NOEs
#

XplorCommand "set message off echo off end"

set noe_3dc [create_MarvinNOEPotential 3dC]

readShiftAssignments \
    -fileName "cvn_3dc_final.shiftAssignments" \
    -pot $noe_3dc

readMarvinPeaks \
    -fileName "cvn_3dc_final.peaks" \
    -pot $noe_3dc


#
# read in the 3dN NOEs
#

XplorCommand "set message off echo off end"

set noe_3dn [create_MarvinNOEPotential 3dN]

readShiftAssignments \
    -fileName "cvn_3dn_final.shiftAssignments" \
    -pot $noe_3dn

readMarvinPeaks \
    -fileName "cvn_3dn_final.peaks" \
    -pot $noe_3dn


puts [residueByResiduePeakReport -pot $noe_3dc -verb]
puts [residueByResiduePeakReport -pot $noe_3dn -verb]
puts [residueByResiduePeakReport -pot [list $noe_3dc $noe_3dn] -verb]



exit
