#
# cyanovirin test
#

package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]

#
# initialization
#

initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}

#
# make sure the initial coords have good covalent geometry
#

cleanCovalentGeom 


#
# set up the 3dC NOEs
#

XplorCommand "set message off echo off end"

set noe_3dc [create_MarvinNOEPotential 3dC]

readShiftAssignments \
    -fileName "cvn_3dc_pass2.shiftAssignments" \
    -pot $noe_3dc

readMarvinPeaks \
    -fileName "cvn_3dc_pass2.peaks" \
    -pot $noe_3dc

readExplicitInverseExceptions \
    -fileName "cvn_3dc.exceptions" \
    -pot $noe_3dc


#
# set up the 3dN NOEs
#

XplorCommand "set message off echo off end"

set noe_3dn [create_MarvinNOEPotential 3dN]

readShiftAssignments \
    -fileName "cvn_3dn_pass2.shiftAssignments" \
    -pot $noe_3dn

readMarvinPeaks \
    -fileName "cvn_3dn_pass2.peaks" \
    -pot $noe_3dn

readExplicitInverseExceptions \
    -fileName "cvn_3dn.exceptions" \
    -pot $noe_3dn



#
# set up the TALOS restraints
#

set talos [create_XplorPot CDIH]

if {$quickMode} {

    readIndividualResidueTalos -fileNames [list
					   ./talos/pred/res004.tab
					   ./talos/pred/res007.tab
					   ./talos/pred/res008.tab
					   ./talos/pred/res009.tab
					   ./talos/pred/res012.tab
					   ./talos/pred/res013.tab
					   ./talos/pred/res014.tab
					   ./talos/pred/res015.tab
					   ./talos/pred/res017.tab
					   ./talos/pred/res018.tab
					   ./talos/pred/res019.tab
					   ./talos/pred/res020.tab
					   ./talos/pred/res021.tab
					   ./talos/pred/res022.tab
					   ./talos/pred/res023.tab
					   ./talos/pred/res024.tab
					   ./talos/pred/res025.tab
					   ./talos/pred/res026.tab
					   ./talos/pred/res029.tab
					   ./talos/pred/res030.tab
					   ./talos/pred/res031.tab
					   ./talos/pred/res033.tab
					   ./talos/pred/res034.tab
					   ./talos/pred/res035.tab]

} else {
    readIndividualResidueTalos -fileNames [glob ./talos/pred/*tab]
}


#
# set up the DELPHIC terms
#

setupDelphicTorsions
set deltorPot [create_XplorPot RAMA]

#
# handle IVM setup
#

setupIVM \
    -toleranceMultiplier 100.0


#
# remarks to tack onto each PDB file
#


set remList [list]

if {$quickMode} {
    set nStructs 20
} else {
    set nStructs 500
}

pass2 \
    -numStructs $nStructs \
    -outFilenameTemplate "cvn_pass2_%d.pdb" \
    -remarksList $remList \
    -potsToUseDuringRandomization [list $talos] \
    -potsToUseDuringAnnealing [list $noe_3dc $noe_3dn $talos $deltorPot] \
    -noePot [list $noe_3dc $noe_3dn] \
    -completeNoePot [list $noe_3dc $noe_3dn] \
    -randomSeed 42 
