#
# Summarizes the results of the first pass Marvin calc,
# picking the best structures and determining constraint
# likelihoods and assignment probabilities for the 
# next pass
# 
# JJK 11/6/02
#

package require marvin

#
# this entire example takes about 12 hours to run on a 60-processor cluster.
# If you just want to verify that things run, run all the scripts with 
# the flag -quick
#

set quickMode [flagExists $argv -quick]


initParamPsfPdb \
    -psfFileName   ./cvn.psf \
    -randomCoords

#
# quick mode will only calculate the structure of the first 36 residues of cyanovirin
#

if {$quickMode} {
    XplorCommand "delete sele (not (resid 1:36)) end"
}

#
# set up the 3dC NOEs
#

XplorCommand "set message off echo off end"

set noe_3dc [create_MarvinNOEPotential 3dC]

readShiftAssignments \
    -fileName "cvn_3dc_pass2.shiftAssignments" \
    -pot $noe_3dc

readMarvinPeaks \
    -fileName "cvn_3dc_pass2.peaks" \
    -pot $noe_3dc

readExplicitInverseExceptions \
    -fileName "cvn_3dc.exceptions" \
    -pot $noe_3dc


#
# set up the 3dN NOEs
#

XplorCommand "set message off echo off end"

set noe_3dn [create_MarvinNOEPotential 3dN]

readShiftAssignments \
    -fileName "cvn_3dn_pass2.shiftAssignments" \
    -pot $noe_3dn

readMarvinPeaks \
    -fileName "cvn_3dn_pass2.peaks" \
    -pot $noe_3dn

readExplicitInverseExceptions \
    -fileName "cvn_3dn.exceptions" \
    -pot $noe_3dn



newSummarizeMarvinResults \
    -fileNames   [glob cvn_pass2_*.pdb] \
    -potList [list $noe_3dc $noe_3dn] \
    -newPeakFile [list cvn_3dc_pass3.peaks cvn_3dn_pass3.peaks] \
    -newShiftAssignmentFile [list cvn_3dc_pass3.shiftAssignments cvn_3dn_pass3.shiftAssignments]\
    -avgPDBfile cvn_pass2_avg.pdb \
    -referenceStructureFile ./cvn_reference.pdb \
    -definedBackbone [AtomSel -args "(name ca or name c or name n)"] \
    -definedHeavyatoms [AtomSel -args "(not name h*)"] 


puts $errorInfo
