
import protocol
protocol.initTopology(["protein","nucleic","ion"])

#xplor.command("@patchForMn-EDTA.inp")

import psfGen

#protein
#
psfGen.seqToPSF("inputs/prot.seq")

from atomSelAction import SetProperty

#dna
#
psfGen.seqToPSF("inputs/nuc1.seq",startResid=99,seqType='dna',segName="TMP1",
                customRename=True)
#strange renumbering
AtomSel("resid 115").apply( SetProperty("residueNum",215) )
AtomSel("resid 116").apply( SetProperty("residueNum",216) )

#break

#second strand
#
psfGen.seqToPSF("inputs/nuc2.seq",startResid=113,seqType='dna',segName="TMP2",
                customRename=True)
#strange renumbering
AtomSel("segid TMP2 and resid 113").apply( SetProperty("residueNum",213) )
AtomSel("segid TMP2 and resid 114").apply( SetProperty("residueNum",214) )

# clear the temporary segids
#
AtomSel("segid TMP2 or segid TMP1").apply( SetProperty("segmentName","") )


## Metal atoms - already included in TED residues
##
#xplor.command("""
#segment
#        SETUP=TRUE
#        number=300
#
#        chain
#          sequence Mn Mn Mn
#          end
#        end
#end""")
#
## create edta-Mn bonds, etc
##
#for residPair in ((215,300),(129,301),(103,302)):
#    xplor.command("patch EMN refe=1=(resid %d) refe=2=(resid %d) end" %
#                  residPair)
#    pass

AtomSel("resid 215 and name MN").apply( SetProperty("residueNum",300) )
AtomSel("resid 129 and name MN").apply( SetProperty("residueNum",301) )
AtomSel("resid 103 and name MN").apply( SetProperty("residueNum",302) )
                  

# rename segid of tag atoms which are replicated 
#
AtomSel("""
 ( (resid 215 or resid 129 or resid 103) and 
    (name CY* or name NY* or name OY* or name HY*
  or name C7  or name H7 or name C8 or name H8
  or name C9  or name O9 or name N10 or name H10
  or name C11 or name H11# or name C12 or name H12# 
  or name N13 or name H13) ) or resid 300:302""").apply(
    SetProperty("segmentName","ALT1"))

# generate additional copies of tag atoms - ALT2 and ALT3
#
for segno in (2,3):
    segid = "ALT%d"%segno
    xplor.command("""
    duplicate
      segid %s
      select = (segid ALT1)
    end""" % segid)



# write out psf
#
xplor.command("write psf output=generate.psf end")

# read in reference coordinates
#
protocol.initCoords('1j46.pdb',useChainID=False)

# parameters for coordinate regularization
#
protocol.initParams(["protein","nucleic"])

import regularize
unknownAtoms = AtomSel("not known")

# add coordinates of unknown atoms and remove bond, angle and improper violations
#
regularize.addUnknownAtoms_new()
protocol.fixupCovalentGeom(sel=unknownAtoms)

# write out starting pdb. The DNA has additional base pairs beyond the input
# structure - these residues will look ugly initially.
#
protocol.writePDB('generate.pdb')


