
# protocol module has many high-level helper functions.
#
import protocol, xplor

protocol.initRandomSeed()   #set random seed - by time

# parameters
protocol.initParams(("protein","nucleic"))

# psf
protocol.initStruct("generate.psf")

inFilename="refine_STRUCTURE.sa"


# coords
protocol.initCoords("generate.pdb")
xplor.simulation.deleteAtoms("resname ANI")

nconf = 3
import protocol, xplor
#
# a PotList contains a list of potential terms. This is used to specify which
# terms are active during refinement.
#
from potList import PotList
potList = PotList()
crossTerms = PotList()

# parameters to ramp up during the simulated annealing protocol
#
from simulationTools import MultRamp, StaticRamp, InitialParams

rampedParams=[]
highTempParams=[]

# compare atomic Cartesian rmsd with a reference structure
#  backbone and heavy atom RMSDs will be printed in the output
#  structure files
#
from posDiffPotTools import create_PosDiffPot
#refRMSD = create_PosDiffPot("refRMSD","name CA or name C or name N",
#                            pdbFile='g_xray.pdb',
#                            cmpSel="not name H*")
#crossTerms.append(refRMSD)

# orientation Tensor - used with the dipolar coupling term
#  one for each medium
#   For each medium, specify a name, and initial values of Da, Rh.
#
from varTensorTools import create_VarTensor, addAxisAtoms
media={}
#                        medium  Da   rhombicity
for (medium,Da,Rh) in [ ('m1',   8.6, 0.61),
                        ('m2',   8.5, 0.6 ),
                        ('m3',   8.0, 0.59), ]:
    oTensor = create_VarTensor(medium)
    oTensor.setDa(Da)
    oTensor.setRh(Rh)
    media[medium] = oTensor
    pass
    

# dipolar coupling restraints for protein amide NH.  
#
# collect all RDCs in the rdcs PotList
#
# RDC scaling. Three possible contributions.
#   1) gamma_A * gamma_B / r_AB^3 prefactor. So that the same Da can be used
#      for different expts. in the same medium. Sometimes the data is
#      prescaled so that this is not needed. scale_toNH() is used for this.
#      Note that if the expt. data has been prescaled, the values for rdc rmsd
#      reported in the output will relative to the scaled values- not the expt.
#      values.
#   2) expt. error scaling. Used here. A scale factor equal to 1/err^2
#      (relative to that for NH) is used.
#   3) sometimes the reciprocal of the Da^2 is used if there is a large
#      spread in Da values. Not used here.
#
from rdcPotTools import create_RDCPot, scale_toNH
rdcs = PotList('rdc') 
for (medium,expt,file,                 scale) in \
    [('m1','NH' , 'inputs/dip_nh.tbl'            ,1),
     ('m1','CAHA','inputs/dip_caha.tbl'        ,1),
     ('m1','HNC', 'inputs/dip_hnc.tbl'           ,0.108),
     ('m1','NCO', 'inputs/dip_nc.tbl'            ,0.05),
     ('m2','HNp', 'inputs/17dip_protnh.tbl'      ,1),
     ('m2','HNd', 'inputs/junk_dna_nh.tbl'       ,1),
     ('m2','CHd',('inputs/final_dna_sug-new.tbl',
                  'inputs/final_dna_aro.tbl'    ),1),
     ('m3','CHg', 'inputs/CAH_gabriel.tbl'       ,1),
     ('m3','HHp', 'inputs/wt_HH_dipy-new.tbl'    ,0),
     ('m3','HHn', 'inputs/HH_dip_negx-new.tbl'   ,0),
     ]:
    rdc = create_RDCPot("%s"%expt,file,media[medium])

    #1) scale prefactor relative to NH
    #   see python/rdcPotTools.py for exact calculation
    # scale_toNH(rdc) - not needed for these datasets -
    #                        but non-NH reported rmsd values will be wrong.

    #3) Da rescaling factor (separate multiplicative factor)
    # scale *= ( 9.9 / rdc.oTensor.Da(0) )**2
    rdc.setScale(scale)
    rdcs.append(rdc)
    pass

for name in ('HHp', 'HHn'):
    pot = rdcs[name]
    scale_toNH(pot)
    pot.setGyroA( 10.46847258 )
    pot.setUseSign(False)
    pot.setPotType('square') #scales rdc values and vary distance dependence
    pass

#from varTensorTools import calcTensorOrientation
#for medium in media.values():
#    calcTensorOrientation(medium)
#    pass

potList.append(rdcs)
rampedParams.append( MultRamp(0.01,1.0, "rdcs.setScale( VALUE )") )


#
# PRE restraints
#
from prePotTools import create_PREPot
pre = PotList('pre')

# add clock pseudo-atoms
#
from prePotTools import addClockAtoms
for resid in range(777,783):
   addClockAtoms(resid)
   pass

#
# for Es2
#
es2at500 = PotList('es2at500')
for (name,file,assignType) in [
    ("Es2hn500","preG2hnSryEs2Mn500.tbl","normal"),
    ("Es2ha500","preG2haSryEs2Mn500.tbl","normal"),
    ("Es2sc500","preG2scSryEs2Mn500.tbl","normal"),
    ("Es2ns500","preG2nsSryEs2Mn500.tbl","nonstereo")]:
    p = create_PREPot(name,"inputs/"+file,assignType,500,clockResid=777)
    es2at500.append(p)
    pass
pre.append(es2at500)

es2at750 = PotList('es2at750')
for (name,file,assignType) in [
    ("Es2ha750","preG2haSryEs2Mn750.tbl","normal"),
    ("Es2sc750","preG2scSryEs2Mn750.tbl","normal"),
    ]:
    p = create_PREPot(name,"inputs/"+file,assignType,750,clockResid=778)
    es2at750.append(p)
    pass
pre.append(es2at750)

#
# for Es3
#
es3at500 = PotList('es3at500')
for (name,file,assignType) in [
    ("Es3hn500","preG2hnSryEs3Mn500.tbl","normal"),
    ("Es3ha500","preG2haSryEs3Mn500.tbl","normal"),
    ("Es3sc500","preG2scSryEs3Mn500.tbl","normal"),
    ("Es3ns500","preG2nsSryEs3Mn500.tbl","nonstereo")]:
    p = create_PREPot(name,"inputs/"+file,assignType,500,clockResid=777)
    es3at500.append(p)
    pass
pre.append(es3at500)

es3at750 = PotList('es3at750')
for (name,file,assignType) in [
    ("Es3ha750","preG2haSryEs3Mn750.tbl","normal"),
    ("Es3sc750","preG2scSryEs3Mn750.tbl","normal"),
    ("Es3ns750","preG2nsSryEs3Mn750.tbl","nonstereo")]:
    p = create_PREPot(name,"inputs/"+file,assignType,750,clockResid=778)
    es3at750.append(p)
    pass
pre.append(es3at750)

#
# for Es4
#
es4at500 = PotList('es4at500')
for (name,file,assignType) in [
    ("Es4hn500","preG2hnSryEs4MnNew500.tbl","normal"),
    ("Es4ha500","preG2haSryEs4MnNew500.tbl","normal"),
    ("Es4sc500","preG2scSryEs4MnNew500.tbl","normal"),
    ("Es4ns500","preG2nsSryEs4MnNew500.tbl","nonstereo")]:
    p = create_PREPot(name,"inputs/"+file,assignType,500,clockResid=781)
    es4at500.append(p)
    pass
pre.append(es4at500)

es4at800 = PotList('es4at800')
for (name,file,assignType) in [
    ("Es4ha800","preG2haSryEs4MnNew800.tbl","normal"),
    ("Es4sc800","preG2scSryEs4MnNew800.tbl","normal"),
    ("Es4ns800","preG2nsSryEs4MnNew800.tbl","nonstereo")]:
    p = create_PREPot(name,"inputs/"+file,assignType,800,clockResid=782)
    es4at800.append(p)
    pass
pre.append(es4at800)

def runSBmode():
    print 'configuring SB mode'
    from prePotTools import setupSBmode
    from simulationTools import flattenPotList
    for p in flattenPotList(pre): setupSBmode(p)
    #apparent tauc
    tcappEs2=2.9
    tcappEs4=3.0
    for p in list(es2at500)+list(es3at500):
        p.setTcType("fix")
        p.setTauC( tcappEs2 )
        pass
    for p in es4at500:
        p.setTcType("fix")
        p.setTauC( tcappEs4 )
        pass
    for p in list(es2at750)+list(es3at750):
        p.setTcType("opt")
        p.setTauC(  tcappEs2       )
        p.setTcMin( tcappEs2       )
        p.setTcMax( tcappEs2 * 1.6 )
    for p in es4at800:
        p.setTcType("opt")
        p.setTauC(  tcappEs4       )
        p.setTcMin( tcappEs4       )
        p.setTcMax( tcappEs4 * 1.6 )
        pass
    return

bbPre = PotList('bbPre')
for p in (es2at500['Es2hn500'], es2at500['Es2ha500'], es2at750['Es2ha750'],
          es3at500['Es3hn500'], es3at500['Es3ha500'], es3at750['Es3ha750'],
          es4at500['Es4hn500'], es4at500['Es4ha500'], es4at800['Es4ha800']):
    bbPre.append(p)
    pass
crossTerms.append(bbPre)

scPre = PotList('scPre')
for p in (es2at500['Es2sc500'], es2at500['Es2ns500'], es2at750['Es2sc750'],
          es3at500['Es3sc500'], es3at500['Es3ns500'],
          es3at750['Es3sc750'], es3at750['Es3ns750'],
          es4at500['Es4sc500'], es4at500['Es4ns500'],
          es4at800['Es4sc800'], es4at800['Es4ns800']):
    p.setScale(0.5)
    scPre.append(p)
    pass
crossTerms.append(scPre)

def runSBMFmode():
    print 'configuring SBMF mode'
    from prePotTools import setupSBMFmode
    from simulationTools import flattenPotList
    for p in flattenPotList(pre): setupSBMFmode(p)
    pre.calcEnergy()
    tcappEs2=2.9
    tcappEs4=3.0
    maxtcEs2 = tcappEs2 / es2at500['Es2hn500'].aveS2()
    maxtcEs4 = tcappEs4 / es4at500['Es4hn500'].aveS2()
    for p in list(es2at500)+list(es3at500):
        p.setTcType("opt")
        p.setTcMin( tcappEs2 )
        p.setTcMax( maxtcEs2 )
        pass
    for p in es4at500 :
        p.setTcType("opt")
        p.setTcMin( tcappEs4 )
        p.setTcMax( maxtcEs4 )
        pass
    for p in list(es2at750)+list(es3at750) :
        p.setTcType("opt")
        p.setTcMin( tcappEs2 )
        p.setTcMax( 1.6*maxtcEs2 )
        pass
    for p in es4at800 :
        p.setTcType("opt")
        p.setTcMin( tcappEs4 )
        p.setTcMax( 1.6*maxtcEs4 )
        pass
    return

potList.append(pre)
rampedParams.append( MultRamp(0.05,1.0, "pre.setScale( VALUE )") )
rampedParams.append( StaticRamp("runSBMFmode()") )
highTempParams.append( StaticRamp("runSBmode()") )

# set up NOE potential
noe=PotList('noe')
potList.append(noe)
from noePotTools import create_NOEPot
for (name,scale,file) in [('noe',1,["inputs/6_22noe_prot_fin.tbl",
                                    "inputs/6_22noe_prot_fin_new.tbl",
                                    "inputs/6_30n15noe_arg.tbl",
                                    "inputs/7_2metonly.tbl",
                                    "inputs/helix_hbond.tbl",
                                    "inputs/dna_trial1-new.tbl", # modified version of dna_trial1.tbl 
                                    "inputs/endnoe_dnax.tbl",
                                    "inputs/pp_trial.tbl",
                                    "inputs/trial_inter3.tbl",
                                    "inputs/6_22nh_inter.tbl",
                                    "inputs/inter_hb.tbl",
                                    "inputs/ends_bdnazzz-new.tbl", # modified version of ends_bdnazzz.tbl
                                    ]),
                          ('hbond',1,["inputs/hbonds_dna-new.tbl",
                                      #"hbonds_dna_edta.tbl", not used here
                                      ])
                          ]:
    pot = create_NOEPot("noe_"+name,file)
    # pot.setPotType("soft") # if you think there may be bad NOEs
    pot.setScale(scale)
    noe.append(pot)
rampedParams.append( MultRamp(2,30, "noe.setScale( VALUE )") )

from xplorPot import XplorPot
# carbon 13 chemical shifts
protocol.initCarb13("inputs/c13_shifts.tbl")
potList.append(XplorPot("CARB"))

# set up J coupling - with Karplus coefficients
from jCoupPotTools import create_JCoupPot
jCoup = create_JCoupPot("jcoup","inputs/hnha_xplr.tbl",
                        A=6.98,B=-1.38,C=1.72,phase=-60.0)
potList.append(jCoup)
x_jCoup = create_JCoupPot("xjcoup","inputs/dna_pcoup.tbl",
                          A=15.3,B=-6.2,C=1.5,phase=120.0)
crossTerms.append(x_jCoup)

# Set up dihedral angles
protocol.initDihedrals(["inputs/dihed_final.tbl",
                        "inputs/dihed_dna_final.tbl",
                        "inputs/dihed_dna_edtaBform.tbl",
                        "inputs/dihed_dna_edtaBformEs3.tbl",
                        "inputs/chi_final-altered.tbl"],
                        useDefaults=0)
potList.append( XplorPot('CDIH') )
highTempParams.append( StaticRamp("potList['CDIH'].setScale(10)") )
rampedParams.append( StaticRamp("potList['CDIH'].setScale(200)") )
# set custom values of threshold values for violation calculation
#
potList['CDIH'].setThreshold( 5 )



# radius of gyration term 
#
protocol.initCollapse("resid 4:81 or resid 105:112 or resid 117:124",
                      Rtarget=15,scale=0.25)
potList.append( XplorPot('COLL') )

#Rama torsion angle database
#
protocol.initRamaDatabase('nucleic')
protocol.initRamaDatabase('protein')
potList.append( XplorPot('RAMA') )
#FIXME: be able to tune nucleic fc separate from protein
rampedParams.append( MultRamp(.002,1,"potList['RAMA'].setScale(VALUE)") )

#initialize the aa-aa positional database
xplor.command("@inputs/bbpd.setup")
potList.append( XplorPot('ORIE') )

#planarity restraints
xplor.command("restraints plane @inputs/dnaPlanBp.tbl end")
potList.append(XplorPot("plan"))

#
# setup parameters for atom-atom repulsive term. (van der Waals-like term)
#
potList.append( XplorPot('VDW') )
rampedParams.append( StaticRamp("protocol.initNBond()") )
rampedParams.append( StaticRamp("setConstraints()") )

rampedParams.append( MultRamp(0.9,0.78,
                         "xplor.command('param nbonds repel VALUE end end')") )
rampedParams.append( MultRamp(.004,4,
                         "xplor.command('param nbonds rcon VALUE end end')") )
# nonbonded interaction only between CA atoms
highTempParams.append( StaticRamp("""protocol.initNBond(cutnb=100,
                                                        rcon=1,
                                                        tolerance=45,
                                                        repel=1.2,
                                                        onlyCA=1)""") )
highTempParams.append(
    StaticRamp(
    xplor.command("""constraints 
       inter = (not (name ca or name p or name mn)) (all) 
       weights * 1 angl 0.4 impr 0.1 vdw 0 elec 0 end 
       inter = (name ca or name p or name mn) (name ca or name p or name mn) 
       weights * 1 angl 0.4 impr 0.1 vdw 1.0 end 
      end""") ) )

def setConstraints():
    #number of conformers (support up to 10 conformers)
    scaleVdw = 1.0 / float( nconf )
    xplor.command("""
      constraints 
      !   interaction (all) (all) 
         inter = (segid " ") (segid " ")
         inter = (segid "ALT1") (segid "ALT1")
         inter = (segid "ALT2") (segid "ALT2")
         inter = (segid "ALT3") (segid "ALT3")
         inter = (segid "ALT4") (segid "ALT4")
         inter = (segid "ALT5") (segid "ALT5")
         inter = (segid "ALT6") (segid "ALT6")
         inter = (segid "ALT7") (segid "ALT7")
         inter = (segid "ALT8") (segid "ALT8")
         inter = (segid "ALT9") (segid "ALT9")
         inter = (segid "ALT0") (segid "ALT0")
         weights * 1 end 
         inter = (segid " ") (segid "ALT1")
         inter = (segid " ") (segid "ALT2")
         inter = (segid " ") (segid "ALT3")
         inter = (segid " ") (segid "ALT4")
         inter = (segid " ") (segid "ALT5")
         inter = (segid " ") (segid "ALT6")
         inter = (segid " ") (segid "ALT7")
         inter = (segid " ") (segid "ALT8")
         inter = (segid " ") (segid "ALT9")
         inter = (segid " ") (segid "ALT0")
         weights * 1 vdw %f end 
      end""" %  scaleVdw )
    return



potList.append( XplorPot("BOND") )
potList.append( XplorPot("ANGL") )
potList['ANGL'].setThreshold( 5 )
rampedParams.append( MultRamp(0.4,1,"potList['ANGL'].setScale(VALUE)") )
potList.append( XplorPot("IMPR") )
potList['IMPR'].setThreshold( 5 )
rampedParams.append( MultRamp(0.1,1,"potList['IMPR'].setScale(VALUE)") )
      





from ivm import IVM
dyn = IVM()

dyn.fix('not (resname ANI or resname TAU)')

# group EDTA-Mn
for res in ([ (215, 300), (129, 301), (103, 302)]) :
   for i in range(0,nconf+1) :
      dyn.group("""segid ALT%-d and
               ((resid %d and (name OY* or name NY* or name HY* or name CY*))
               or resid %d)""" % (i, res[0], res[1]))
      pass
   pass




# initialize ivm topology for torsion-angle dynamics

for m in media.values():
    m.setFreedom("fixDa, fixRh")        #fix tensor Rh, Da, vary orientation
#    m.setFreedom("varyDa, varyRh")      #vary tensor Rh, Da, vary orientation
protocol.torsionTopology(dyn)

def analyzeOneStructure(loopInfo):
    """ this function analyzes a single structure,
    and then writes out a pdb file, with remarks.
    """

    try:
        protocol.initCoords( loopInfo.makeFilename(inFilename) )

        FinalParams(highTempParams)
        FinalParams(rampedParams)

        # do minimization to calculate appropriate tauc
        protocol.initMinimize(dyn,
                              potList=potList,
                              numSteps=1000,
                              )
        dyn.run()
        
        #recalculate alignment tensors for each structures
        # comment this out is you wish to use tensor parameters contained
        # within the coordinate files.
        from varTensorTools import calcTensor
        for medium in media.values():
            calcTensor(medium)
            pass
    
        #do analysis and write structure
        loopInfo.writeStructure(potList)
    except IOError:
        #missing structure
        pass
    pass



from simulationTools import StructureLoop, FinalParams
sl=StructureLoop(structureNums=range(64),
                 pdbTemplate="SCRIPT_STRUCTURE.pdb",
                 structLoopAction=analyzeOneStructure,
                 genViolationStats=1,
                 averageTopNum=20, #report only on best 20 structs
                 averageSortPots=[potList['BOND'],potList['ANGL'],
                                  potList['IMPR'],
                                  noe,rdcs,potList['CDIH']],
                 averagePotList=potList,
                 averageCrossTerms=crossTerms,
                 averageContext=FinalParams(rampedParams),
                 averageFilename="SCRIPT_ave.pdb",
                 averageFitSel="""(resid 4:79 and (name CA or name C or
                                                   name N  or name O)) or
                                  ((resid 101:112 or resid 116:127) and
                                   not name H* and not segid ALT*)""",
                 averageCompSel="""(resid 4:79 or resid 101:112 or
                                    resid 116:127) and not name H*
                                    and not segid ALT*"""     )
sl.run()


import trace
trace.suspend()
if xplor.p_comm.procNum==0:

    print "Summary"
    print
    print "precision of structures to mean: %.2f (heavy atom: %.2f)" \
          % (sl.fitRMSD,sl.compRMSD)
    
    # the published precisions are to nonregularized mean structure
    # but we're compariing to a regularized structure
    #
    refPrec=0.7   #prot. bb+ DNA heavy atom 0.21 +/- 0.06Angstrom
    refPrec1=0.8  #heavy atom               0.53 +/- 0.06Angstrom
    ok=True
    if sl.fitRMSD>refPrec:
        print "Error: bad backbone precision"
        ok=False
        pass
    if sl.compRMSD>refPrec1:
        print "Error: bad heavy atom precision"
        ok=False
        pass

    bondStats = sl.restraintStats.potTypes['XplorPot']['BOND']
    (bondRMSD,bondRMSDdev) = bondStats.rmsdAveDev()

    refBondRMSD=0.007
    if bondRMSD>refBondRMSD:
        print "Error: bad bond rmsd"
        ok=False
        pass

    angleStats = sl.restraintStats.potTypes['XplorPot']['ANGL']
    (angleRMSD,angleRMSDdev) = angleStats.rmsdAveDev()

    refAngleRMSD=0.91
    if angleRMSD>refAngleRMSD:
        print "Error: bad angle rmsd"
        ok=False
        pass

    imprStats = sl.restraintStats.potTypes['XplorPot']['IMPR']
    (imprRMSD,imprRMSDdev) = imprStats.rmsdAveDev()

    refImprRMSD=0.62
    if imprRMSD>refImprRMSD:
        print "Error: bad impr rmsd"
        ok=False
        pass

    cdihStats = sl.restraintStats.potTypes['XplorPot']['CDIH']
    (cdihRMSD,cdihRMSDdev) = cdihStats.rmsdAveDev()

    refCdihRMSD=0.9 #0.64
    if cdihRMSD>refCdihRMSD:
        print "Error: bad cdih rmsd"
        ok=False
        pass

    carbStats = sl.restraintStats.potTypes['XplorPot']['CARB']
    (carbRMSD,carbRMSDdev) = carbStats.rmsdAveDev()

    refCarbRMSD=1.03
    if carbRMSD>refCarbRMSD:
        print "Error: bad carb rmsd"
        ok=False
        pass

    noeStats = sl.restraintStats.potTypes['PotList']['noe']
    (noeRMSD,noeRMSDDev) = noeStats.rmsdAveDev()
    
    refNoeRMSD=0.05
    if noeRMSD>refNoeRMSD:
        print "Error: bad noe rmsd"
        ok=False
        pass

    jcoupStats = sl.restraintStats.potTypes['JCoupPot']['jcoup']
    (jcoupRMSD,jcoupRMSDDev) = jcoupStats.rmsdAveDev()
    
    refJcoupRMSD=1.1 #0.89
    if jcoupRMSD>refJcoupRMSD:
        print "Error: bad jcoup rmsd"
        ok=False
        pass

    hhRDCStats = sl.restraintStats.potTypes['RDCPot1']['HHn']
    (hhRDCRMSD,hhRDCRMSDDev) = hhRDCStats.rmsdAveDev()
    
    refHHrdcRMSD=1.0 # should be 0.53
    if hhRDCRMSD>refHHrdcRMSD:
        print "Error: bad RDC(HHn) rmsd"
        ok=False
        pass

    nhRDCStats = sl.restraintStats.potTypes['RDCPot1']['NH']
    (nhRDCrmsd,nhRDCdev) = nhRDCStats.extraStatsAveDev('R-fac')

    refNHRDCrmsd=6.5 #5.7
    if nhRDCrmsd>refNHRDCrmsd:
        print "Error: bad NH R-factor"
        ok=False
        pass

    cahaRDCStats = sl.restraintStats.potTypes['RDCPot1']['CAHA']
    (cahaRDCrmsd,cahaRDCdev) = cahaRDCStats.extraStatsAveDev('R-fac')

    refCAHARDCrmsd=8 #5.54
    if cahaRDCrmsd>refCAHARDCrmsd:
        print "Error: bad CAHA R-factor",  cahaRDCrmsd, ">" ,refCAHARDCrmsd
        ok=False
        pass

    ncoRDCStats = sl.restraintStats.potTypes['RDCPot1']['NCO']
    (ncoRDCrmsd,ncoRDCdev) = ncoRDCStats.extraStatsAveDev('R-fac')

    ncoRDCrmsdRef=23.9
    if ncoRDCrmsd>ncoRDCrmsdRef:
        print "Error: bad NCO R-factor"
        ok=False
        pass

    hncRDCStats = sl.restraintStats.potTypes['RDCPot1']['HNC']
    (hncRDCrmsd,hncRDCdev) = hncRDCStats.extraStatsAveDev('R-fac')

    hncRDCrmsdRef=22 # 20.4
    if hncRDCrmsd>hncRDCrmsdRef:
        print "Error: bad HNC R-factor"
        ok=False
        pass

    hndRDCStats = sl.restraintStats.potTypes['RDCPot1']['HNd']
    (hndRDCrmsd,hndRDCdev) = hndRDCStats.extraStatsAveDev('R-fac')

    hndRDCrmsdRef=11.0
    if hndRDCrmsd>hndRDCrmsdRef:
        print "Error: bad HNd R-factor"
        ok=False
        pass

    chdRDCStats = sl.restraintStats.potTypes['RDCPot1']['CHd']
    (chdRDCrmsd,chdRDCdev) = chdRDCStats.extraStatsAveDev('R-fac')

    chdRDCrmsdRef=14.0
    if chdRDCrmsd>chdRDCrmsdRef:
        print "Error: bad CHd R-factor"
        ok=False
        pass

    oPREStats = sl.restraintStats.potTypes['PotList']['pre']
    (oPREave,oPREdev) = oPREStats.extraStatsAveDev('Q-factor')

    oPREaveRef=0.29 #0.24
    if oPREave>oPREaveRef:
        print "Error: bad average overall Q-factor "
        ok=False
        pass

    bbPREStats = sl.restraintStatsCross.potTypes['PotList']['bbPre']
    (bbPREave,bbPREdev) = bbPREStats.extraStatsAveDev('Q-factor')

    bbPREaveRef=0.26 #0.20
    if bbPREave>bbPREaveRef:
        print "Error: bad backbone average PRE Q-factor "
        ok=False
        pass

    scPREStats = sl.restraintStatsCross.potTypes['PotList']['scPre']
    (scPREave,scPREdev) = scPREStats.extraStatsAveDev('Q-factor')

    scPREaveRef=0.31 #0.27
    if scPREave>scPREaveRef:
       print "Error: bad sidechain average Q-factor "
       ok=False
       pass

    refRMSD=0.75 # accuracy of ave. to ave. of Junji's original script
    
    from xplorSimulation import XplorSimulation
    xsim=XplorSimulation(1) # clone the current simulation - so the psf is same
    refSelection=AtomSel("all",xsim)
    protocol.initCoords("refStruct.pdb",selection=refSelection)
    from atomSelAction import RMSD, Fit
    fitSel='''(resid 4:79 and name CA) or
              (resid 101:112 or resid 116:127)
              and not name H* and not segid ALT*'''
    refSelection.apply(Fit(AtomSel(fitSel     ),
                           AtomSel(fitSel,xsim)))
    rmsd=RMSD(fitSel)
    AtomSel(fitSel,xsim).apply(rmsd)
    

    print "RMSD to reference structure: %.2f" %  rmsd.rmsd()
    if rmsd.rmsd()>refRMSD:
       print "Error: bad RMSD to reference structure: %.2f" %  rmsd.rmsd()
       ok=False
       pass
       

    
    
    #print
    #print "Violations: total: %f(%f)   NOE: %f(%f)"
    #print 
    #also want statistics:
    #  sl will need to hang on to RestraintStats object
    #  requires rework of restraintStats to make TermEntry a proper class
    #  with methods to get desired stats
    #  #viols
    
#    totStats = sl.restraintStats.potTypes['PotList']['TOTAL']
#    (totViols,totViolsDev) = totStats.violationsAveDev()
#    
#    print
#    print "Violations: total: %f(%f)   NOE: %f(%f)" %(totViols,totViolsDev,
#                                                      noeViols,noeViolsDev)
    print 
    
    if not ok:
        raise Exception("low quality results")

    open("ok.tmp","w").write("validation succeeded")
            
## read in coordinate or statistics file and verify:
#
#PRE
#overall (438) 0.23 ( 0.01 
#backbone (258) 0.20 ( 0.00 
#side chain (180) 0.26 ( 0.01
#                        
