#!/usr/bin/env pyXplor

#
import sys
usage=r'''
 usage: %s [option] file1[suff] ...

 suff is an optional colon-separated list of column numbers and style
 strings. There can be one, two or three (offset 1) column numbers,
 corresponding to y-only, x,y, or x,y,dy data, respectively.

 Using the filename stdin causes input to be read from stdin.
 

 option is zero or more of
 -xmax <val>   - plot bounds
 -xmin  <val>
 -ymax <val>   - plot bounds
 -ymin  <val>
 -xlabel <text> - axis labels
 -ylabel <text>
 -label  <x:y:text>  - place extra label on plot
 -outFile <filename> - name of output file.
 -normalizeIndex <val> - how to normalize the curves to each other
                         (default - no normalization)
 -suffix <suffix>      - specify default suffix for all files
 -vline <val>          - draw vertical line at val
 -hline <val>          - draw horizontal line at val
 -xticks <vals>        - colon-separated xtick values
 -yticks <vals>        - colon-separated ytick values

 -numRows <val>        - number of rows of subplots
 -curRow  <val>        - current row for option specification -
                          rows are numbered from 0, and from bottom to top
 -plotType <linear:log>- type of plot for current row
 -markerSize           - scale for symbol size of scatter points.
''' % sys.argv[0]
#

plotLog=[True] if 'plotLog' in sys.argv[0] else [False]


(opts,files) = xplor.parseArguments(['xmax:1',
                                     'xmin:1',
                                     'ymax:1',
                                     'ymin:1',
                                     'xlabel:1',
                                     'ylabel:1',
                                     'xticks:1',
                                     'yticks:1',
                                     'markersize:1',
                                     'label:1',
                                     'outFile:1',
                                     'vline:1',
                                     'hline:1',
                                     'suffix:1',
                                     'normalizeIndex:1',
                                     'numRows:1',
                                     'curRow:1',
                                     'rect:1',
                                     'plotType:1',
                                     'noyticklabel:0',
                                     'help-script'])

maxx=None
minx=None
normalizeIndex=-1
xlabel=None
outFilename=None
suffix="1:2:3:-o"
labels=[]
showyticklabels=[True]
numRows=1
curRow=0
maxy=[None  ]
miny=[None  ]
vlines=[]
hlines=[]
ylabel=[None]
xticks=[None]
yticks=[None]
markersize=[None]
rects=[(0.15,0.15,0.8,0.8)]

import sys
for opt in opts:
    if opt[0]=='xmax':
        maxx=float(opt[1])
        pass
    if opt[0]=='xmin':
        minx=float(opt[1])
        pass
    if opt[0]=='normalizeIndex':
        normalizeIndex=int(opt[1])
        pass
    if opt[0]=='xlabel':
        xlabel=opt[1]
        pass
    if opt[0]=='label':
        labels.append(opt[1])
        pass
    if opt[0]=='outFile':
        outFilename=opt[1]
        pass
    if opt[0]=='suffix':
        suffix=opt[1]
        pass
    if opt[0]=='numRows':
        numRows=int(opt[1])
        maxy=[None  ]*numRows
        miny=[None  ]*numRows
        ylabel=[None]*numRows
        xticks=[None]*numRows
        yticks=[None]*numRows
        markersize=[None]*numRows
        plotLog=[plotLog[0]]*numRows
        showyticklabels=[showyticklabels[0]]*numRows
        rects=[]
        width=0.8
        height=0.8/numRows
        left=0.15
        for row in range(numRows):
            bot= 0.15+ row *height
            rects.append( (left,bot,width,height) )
            pass
        pass
    if opt[0]=='curRow':
        curRow=int(opt[1])
        pass

    if opt[0]=='plotType':
        if opt[1]!='linear' and opt[1]!='log':
            print 'invalid argument for -plotType option:',opt[1]
            print usage
            sys.exit(1)
            pass
        plotLog[curRow]=False if opt[1]=='linear' else True
        pass
    if opt[0]=='rect':
        rects[curRow] = map(lambda x: float(x), opt[1].split(':'))
        if len(rects[curRow])!=4:
            print "bad rect specification:", opt[1]
            print "should be: left:bot:width:height"
            print sys.exit(1)
            pass
        pass
    if opt[0]=='ymax':
        maxy[curRow] = float(opt[1])
        pass
    if opt[0]=='ymin':
        miny[curRow] =float(opt[1])
        pass
    if opt[0]=='ylabel':
        ylabel[curRow] =opt[1]
        pass
    if opt[0]=='xticks':
        xticks[curRow] =map(lambda x: float(x), opt[1].split(':'))
        pass
    if opt[0]=='yticks':
        yticks[curRow] =map(lambda x: float(x), opt[1].split(':'))
        pass
    if opt[0]=='markersize':
        markersize[curRow] = float(opt[1])
        pass
    if opt[0]=='vline':
        vlines.append(opt[1])
        pass
    if opt[0]=='hline':
        hlines.append(opt[1])
        pass
    if opt[0]=='noyticklabel':
        showyticklabels[curRow]=False
        pass
    if opt[0]=='help-script':
        print usage
        sys.exit(0)
    pass


from pylab import figure, arange, randn, exp, xlim, ylim, show
import pylab
pylab.rcParams['axes.linewidth'] = 1
pylab.rcParams['lines.linewidth'] = 1
pylab.rcParams['font.size'] = 18
pylab.rcParams['xtick.major.size'] =8      # major tick size in points
pylab.rcParams['ytick.minor.size'] =4      # minor tick size in points
pylab.rcParams['figure.subplot.bottom'] = 0.13
defMarkersize = pylab.rcParams['lines.markersize']

#pylab.rcParams(xtick.major.pad = 4      # distance to major tick label in points
#xtick.minor.pad      : 4      # distance to the minor tick label in points
#xtick.color          : k      # color of the tick labels
#xtick.labelsize      : medium # fontsize of the tick labels
#x

t = arange(0.1, 4, 0.1)
s = exp(-t)
e = 0.1*abs(randn(len(s)))
f = 0.1*abs(randn(len(s)))
g = 2*e
h = 2*f

import sys

ymin=[1e30]*numRows
ymax=[-1e30]*numRows
xmin=1e30
xmax=-1e30
emax=0


fig=figure(facecolor='w')
pylab.subplots_adjust(hspace=0.001)
ax=[]

for row in range(numRows):
    plotGeom=numRows*100 + 10 + numRows-row
    kwargs={}
    if row>0:
        kwargs['sharex']=ax[0]
        pass
    if plotLog[row]:
        kwargs['yscale']='log'
    else:
        kwargs['yscale']='linear'
        pass
    
#    ax.append( fig.add_subplot(plotGeom, **kwargs) )
    ax.append( fig.add_axes(rects[row], **kwargs) )
    pass

def is_atol(s):
    import string
    try:
        string.atol(s)
    except string.atol_error:
        return False
    return True

class RetType:
    pass

def splitArgColsStyle(arg,
                      defaultCols=(0,1,2),
                      defaultStyle="-o",
                      defaultRow=0):
    """
    split off colon-separated column numbers and style strings
    from preceeding filename (arg) or other argument.

    style is 1st non-integer element.

    A double : (::) delimits a row number from other args/options.
    """
    ret=RetType
    ret.cols=tuple(defaultCols)
    ret.arg=arg
    ret.style=str(defaultStyle)
    ret.row=defaultRow
    ret.kwargs={}
    if ret.arg.find(":")>=0:
        suff=ret.arg[ret.arg.find(":")+1:]
        ret.arg=ret.arg.split(":")[0]
        if suff.find("::")>=0:
            (suff,row)=suff.split("::")
            ret.row=int(row)
            pass
        colstry = map(lambda s: int(s)-1,
                      filter(is_atol, suff.split(':')))
        if colstry: ret.cols = colstry
        rest = filter(lambda s: not is_atol(s),suff.split(':'))
        if len(rest):
            ret.style = rest[0]
            pass
        if len(rest)>1:
            for pair in rest[1:]:
                (name,val)=pair.split('=')
                ret.kwargs[name]=float(val)
                pass
            pass
#        print ret.arg, ret.cols,ret.style,ret.row
#        print ret.options
        pass
    
    return ret

defVals=splitArgColsStyle("0:"+suffix)
dcols,dstyle,drow = (defVals.cols,defVals.style,defVals.row)

for file in files:

    getArgs = splitArgColsStyle(file,dcols,dstyle,drow)
#    import sys; sys.exit(0)
    (file,cols,style,row) = (getArgs.arg,getArgs.cols,
                             getArgs.style,getArgs.row) 

    if file=="stdin":
        lines=sys.stdin.readlines()
    else:
        lines=open(file).readlines()
        pass

    xarray=None
    yarray=[]
    earray=None
    for line in lines:
        data=[]
        try:
            for col in cols:
                try:
                    data.append( float(line.split()[col]) )
                except:
                    raise
                pass


            if len(cols)==1:
                yarray.append(data[0])
            elif len(cols)==2:
                if xarray==None:xarray=[]
                xarray.append(data[0])
                yarray.append(data[1])
            elif len(cols)==3:
                if xarray==None:xarray=[]
                if earray==None:earray=[]
                xarray.append(data[0])
                yarray.append(data[1])
                earray.append(data[2])
                pass
        except:
            continue

        pass

    norm=1
    if normalizeIndex!=-1:
        norm=1./yarray[normalizeIndex]
        pass

    yarray=map(lambda v:v*norm, yarray)
    if earray: earray=map(lambda v:v*norm, earray)
        


    ymin[row]=min(ymin[row],
                  reduce(lambda x,y: min(x,y), yarray))
    ymax[row]=max(ymax[row],
                  reduce(lambda x,y: max(x,y), yarray))
    xmin=min(xmin,
             reduce(lambda x,y: min(x,y), xarray))
    xmax=max(xmax,
             reduce(lambda x,y: max(x,y), xarray))

    markerSize=markersize[row] * defMarkersize \
                if markersize[row] else defMarkersize

    #zorder controls order of drawing.
    # larger values are drawn last and appear on top
    # the errorbar line is drawn with a zorder of 2 regardless of
    # specification (in version 0.99.0).

    if earray:
        p=ax[row].errorbar(xarray, yarray, yerr=earray, fmt=style,
                           markersize=markerSize,
                           ecolor='grey',**getArgs.kwargs)#,capsize=5)
    else:
        p=ax[row].plot(xarray, yarray, style,
                       markersize=markerSize,
                       **getArgs.kwargs)
        pass
    pass

if xlabel!=None: ax[0].set_xlabel(xlabel,size=20)

if minx==None: minx= xmin
if maxx==None: maxx= xmax
for row in range(numRows):
    if miny[row]==None: miny[row]= ymin[row]-2*emax
    if maxy[row]==None: maxy[row]= ymax[row]+2*emax
    if ylabel[row]!=None: ax[row].set_ylabel(ylabel[row],size=20)
    pass

for vline in vlines:
    getArgs=splitArgColsStyle(vline,
                              defaultStyle="-",
                              defaultRow=drow)
    val,style,row = (getArgs.arg,getArgs.style,getArgs.row)
    ax[row].plot([val,val],[miny,maxy],style)
    pass
for hline in hlines:
    getArgs=splitArgColsStyle(hline,
                              defaultStyle="-",
                              defaultRow=drow)
    val,style,row = (getArgs.arg,getArgs.style,getArgs.row)
    ax[row].plot([minx,maxx],[val,val],style)
    pass

for label in labels:
    row=drow
    if label.find("::")>=0:
        (label,row)=label.split("::")
        row=int(row)
        pass
    (x,y,text) = label.split(':')[:3]
    x=float(x)
    y=float(y)
    ax[row].text(x,y,text,
                 horizontalalignment='center')
    
        
for row in range(numRows):
    ax[row].set_ylim(miny[row],maxy[row])
    ax[row].set_xlim(minx,maxx)
    pass



xticklabels = []
yticklabels = []
for row in range(1,numRows):
    xticklabels.append( ax[row].get_xticklabels() )
    pylab.setp(xticklabels, visible=False)
    yticklabels.append( ax[row].get_yticklabels() )
    pylab.setp(yticklabels, visible=showyticklabels[row])
    pass

for row in range(numRows):
    if xticks[row]!=None:
        ax[row].set_xticks(xticks[row])
        pass
    if yticks[row]!=None:
        ax[row].set_yticks(yticks[row])
        pass
    pass
        



if outFilename:
    pylab.savefig(outFilename)
else:
    show()
    pass


